<?php

namespace Database\Seeders\MercuryTheme;

use Illuminate\Database\Seeder;
use Mtc\ContentManager\Facades\Page as PageFacade;
use Mtc\ContentManager\Models\Content;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\Models\Template;
use Mtc\ContentManager\PageStatus;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Page::query()->truncate();
        Content::query()->truncate();

        collect($this->getList())
            ->each(function ($entry) {
                $page = PageFacade::create($entry['title'], $entry['template_id']);
                $page->update([
                    'slug' => $entry['slug'],
                    'status' => $entry['status'],
                ]);
        });
    }

    public function getList()
    {
        return [
            [
                'title' => 'Homepage',
                'slug' => 'home',
                'status' => PageStatus::PUBLISHED->value,
                'template_id' => Template::query()->where('slug', 'home')->first()->id ?? 0,
            ],
        ];
    }
}
