<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VisitorSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Visitor',
                'name' => 'Enabled',
                'config_key' => 'chat-visitor-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://visitor.chat/" target="_blank">Visitor</a> chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Visitor',
                'name' => 'Speech bubble text',
                'config_key' => 'chat-visitor-sb_text',
                'type' => 'string',
                'value' => '',
                'order' => 1,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Visitor',
                'name' => 'Call to action title',
                'config_key' => 'chat-visitor-cta_title',
                'type' => 'string',
                'value' => '',
                'order' => 2,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Visitor',
                'name' => 'Call to action text',
                'config_key' => 'chat-visitor-cta_text',
                'type' => 'string',
                'value' => '',
                'order' => 3,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Visitor',
                'name' => 'Id',
                'config_key' => 'chat-visitor-id',
                'type' => 'string',
                'value' => '',
                'order' => 4,
                'description' => 'Optional. This will be supplied to you by your visitor account manager.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Visitor',
                'name' => 'Name',
                'config_key' => 'chat-visitor-name',
                'type' => 'string',
                'value' => '',
                'order' => 5,
                'description' => 'Optional. This will be supplied to you by your visitor account manager.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Visitor',
                'name' => 'Account ID',
                'config_key' => 'chat-account_id-name',
                'type' => 'string',
                'value' => '',
                'order' => 6,
                'description' => 'Optional. This will be supplied to you by your visitor account manager.'
            ],
        ];
    }
}
