<?php

namespace Tests\Feature;

use App\Models\Report;
use Illuminate\Support\Facades\App;
use Tests\TenantTestCase;

class ReportRepositoryTest extends TenantTestCase
{

    public function testUpdate()
    {
        $report = Report::factory()->create([
            'schedule' => 'daily',
        ]);

        $report = Report::query()->find($report->id);

        $request = request()->merge([
            'schedule' => 'weekly',
            'name' => 'foo',
            'type' => 'vehicles',
            'active' => true,
            'recipient' => [
                'test@mail.com'
            ]
        ]);
        App::make(ReportEngineRepository::class)->update($request, $report);

        $report->refresh();
        $this->assertEquals('weekly', $report->schedule);
        $this->assertEquals('foo', $report->name);
        $this->assertEquals('vehicles', $report->type);
    }

    public function testShow()
    {
        $report = Report::factory()->create([
            'schedule' => 'daily',
        ]);

        $report = Report::query()->find($report->id);

        $request = request()->merge([
            'schedule' => 'weekly',
            'name' => 'foo',
            'type' => 'vehicles',
            'active' => true,
            'recipient' => [
                'test@mail.com'
            ]
        ]);
        App::make(ReportEngineRepository::class)->update($request, $report);
        $result = App::make(ReportEngineRepository::class)->show($report)->toArray();
        $this->assertArrayHasKey('data_options', $result);
        $this->assertArrayHasKey('columns', $result);
        $this->assertArrayHasKey('conditions', $result);
        $this->assertArrayHasKey('logs', $result);
    }
}
