<?php

namespace Tests\Feature;

use App\Facades\Site;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Tests\TestCase;
use Tests\UserForTenant;

class SiteRepositoryTest extends TestCase
{
    use DatabaseMigrations;
    use UserForTenant;

    protected $tenancy = true;

    public function testGetSiteUrl()
    {
        tenant()->domains()->update([
            'verified' => true,
        ]);
        $url = Site::url('/foo');

        $this->assertEquals('https://test.localhost/foo', $url);
    }
}
