<?php

namespace App\Traits;

use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;

trait MakeAndModelList
{
    private function getMakeList(): Collection
    {
        return VehicleMake::query()
            ->with('filterIndex')
            ->select('name', 'id')
            ->get();
    }

    private function getModelList(?int $makeId): Collection
    {
        return $makeId
            ? VehicleModel::query()
                ->with('filterIndex')
                ->select('name', 'id')
                ->ofMake($makeId)
                ->get()
            : collect();
    }
}
