<?php

namespace Tests\Feature;

use App\Events\TenantBroadcastEvent;
use App\NotificationRepository;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Event;
use Mtc\Notifications\Models\Notification;
use Tests\TestCase;
use Tests\UserForTenant;

class NotificationRepositoryTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testNotify()
    {
        /** @var NotificationRepository $repository */
        $repository = App::make(NotificationRepository::class);
        Event::fake();
        $repository->addNotification('error', 'foo', 'test', null, '/foo');
        Event::assertDispatched(TenantBroadcastEvent::class);

        $exists = Notification::query()
            ->where('severity', 'error')
            ->where('source', '/foo')
            ->where('message', 'foo')
            ->exists();

        $this->assertTrue($exists);
    }

}
