<?php

namespace Tests\Feature;

use App\ReportTypes\OfferReport;
use App\ReportTypes\VehicleReport;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Tests\TestCase;
use Tests\UserForTenant;

class ReportTypeTest extends TestCase
{
    use DatabaseMigrations;
    use UserForTenant;

    protected $tenancy = true;

    public function testVehicleReport()
    {
        $this->assertIsString((new VehicleReport())->name());
        $columns = (new VehicleReport())->columns();
        $this->assertIsArray($columns);
        $this->assertArrayHasKey('vin', $columns);
        $this->assertArrayHasKey('mpg', $columns);
        $this->assertArrayHasKey('derivative', $columns);
        $this->assertArrayHasKey('cap_id', $columns);
        $this->assertArrayHasKey('auto_trader_id', $columns);

        $vehicle = Vehicle::factory()->create();
        $query = (new VehicleReport())->query();
        $this->assertTrue($vehicle->is($query->first()));
    }

    public function testOfferReport()
    {
        $this->assertIsString((new OfferReport())->name());
        $columns = (new OfferReport())->columns();
        $this->assertIsArray($columns);
        $this->assertArrayHasKey('slug', $columns);
        $this->assertArrayHasKey('price', $columns);
        $this->assertArrayHasKey('name', $columns);

        $offer = VehicleOffer::factory()->create();
        $query = (new OfferReport())->query();
        $this->assertTrue($offer->is($query->first()));
    }
}
