<?php

namespace App\Actions\IntegrationVerification;

use App\VehicleSpec\Config\MotorCheckConfig;
use App\VehicleType;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MotorCheck\Services\MotorCheckService;

class VerifyMotorCheckSpecs
{
    public function __construct(private readonly MotorCheckConfig $config)
    {
        Config::set('motor_check.specs_username', $config->clientId());
        Config::set('motor_check.specs_password', $config->clientSecret());

        Config::set('motor_check.enabled', $config->enabled());
        Config::set('motor_check.allow_local_cache', false);
        Config::set('motor_check.live', true);
        Config::set('motor_check.specs_live', true);
    }

    public function verify(): bool
    {
        $motorCheck = App::make(MotorCheckService::class);
        $specs = $motorCheck->getCarSpecs('KN23XMD');
        return !empty($specs->UUID);
    }
}
