# Front-end Authentication

## MTC Staff Login (OTP-based)

This system uses OTP (One-Time Password) authentication for MTC staff members logging into production systems.

### Production Systems

When an MTC staff member (@mtc.co.uk or @mtcmedia.co.uk email) attempts to log in to a production system, they must:

1. Visit the [MTC CVCS System](https://projects.mtcmedia.co.uk/staff/cvcs)
2. Find the correct host/domain for the system they want to access
3. Request Admin OTP for that account
4. After approval, an email will be sent with a link to view the OTP code
5. Use their email and the received OTP code **in place of their password** to log in

The system sends the current domain to the Projects API during authentication to validate the OTP. Each OTP can only be used once and expires after a set period.

### Local Development

For local development environments (`localhost` domains), OTP authentication is **disabled**. Developers can log in using their standard Projects system password without requesting an OTP.

### Error Messages

If authentication fails, the system will display error messages from the Projects API to help users understand what went wrong (e.g., "Invalid or expired OTP").

---

## API Endpoints

### Login

`POST /api/login`
```json
{
    "email": "john@example.com",
    "password": "securePassword2"
}
```
Responses:

200 - OK
```json
{"two_factor":false}
```

422 - Unprocessable Entity
```json
{"message":"The given data was invalid.","errors":{"email":["These credentials do not match our records."]}}
```

___

### Logout

`POST /api/login`
Responses:

204 - No Content

___
### Forgot Password

`POST /api/login`
```json
{
    "email": "john@example.com",
}
```
Responses:

200 - OK 

```json
{"message":"We have emailed your password reset link!"}
```
* Will trigger email notification.

422 - Unprocessable Entity
```json
{"message":"The given data was invalid.","errors":{"email":["The email field is required."]}}
```


___
### Reset Password

`POST /api/reset-password`
```json
{
    "email": "john@example.com",
    "token": "PASSWORD_RESET_TOKEN",
    "password": "securePassword2",
    "password_confirmation": "securePassword2"
}
```
Responses:

200 - OK

```json
{"message":"Your password has been reset!"}
```

422 - Unprocessable Entity
```json
{"message":"The given data was invalid.","errors":{"email":["This password reset token is invalid."]}}
```

___
### Update profile information

`PUT api/user/profile-information`
```json
{
    "name" : "John Doe",
    "email": "john@example.com"
}
```
