<?php

namespace App\Master\Http\Requests;

use App\Models\ContentSync;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class CreateContentSyncRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check() && Auth::user()->hasRole('mtc');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'tenant_id' => [
                'required',
                'exists:tenants,id'
            ],
            'direction' => [
                'required',
                Rule::in([ContentSync::PULL, ContentSync::PUSH, ContentSync::PROVIDE, ContentSync::RECEIVE]),
            ],
            'environment' => [
//                'required_if:direction,down'
            ],
            'scope' => [
//                'required_if:direction,down'
            ],
            'selections' => [
//                'required_if:direction,down'
            ],
            'data' => [
                'boolean',
            ]
        ];
    }
}
