<?php

namespace App\Console\Commands;

use App\AIContentRepository;
use App\Facades\Settings;
use App\Jobs\CreateAIVehicleDescriptions;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;

class GenerateBulkVehiclesAIContentDescriptions extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ai-content:generate-bulk-vehicles-description {--retry}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate bulk vehicle descriptions using enabled AI Content integration';

    public function __construct(
        protected AIContentRepository $AIContentRepository
    ) {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (!$this->AIContentRepository->hasEnabledIntegration()) {
            $this->info(__('ai-content.integration_not_enabled'));
            return 0;
        }

        $this->dispatchSync(new CreateAIVehicleDescriptions($this->option('retry')));

        $this->info('Descriptions generated successfully.');
        return 0;
    }
}
