<?php

namespace App\Master\Http\Requests;

use App\Tier;
use Illuminate\Validation\Rule;
use JetBrains\PhpStorm\ArrayShape;

class SiteStoreRequest extends SiteRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    #[ArrayShape(['name' => "string"])] public function rules()
    {
        return [
            'name' => 'required',
            'tier' => [
                'required',
                Rule::in(array_map(static fn (Tier $tier) => $tier->value, Tier::cases()))
            ],
        ];
    }
}
