<?php

namespace App\Reporting;

use App\Contracts\ReportTile;
use Carbon\Carbon;
use Illuminate\Contracts\Support\Arrayable;
use Mtc\MercuryDataModels\Enquiry;

class EnquiryKPI implements Arrayable
{
    public function toArray()
    {
        return [
            'name' => 'Number of enquiries',
            'value' => Enquiry::query()
                ->where('created_at', '>=', Carbon::now()->startOfDay())
                ->count(),
            'scope' => 'Today',
        ];
    }
}
