<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutomotiveSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'General',
                'name' => 'Distance measurement',
                'config_key' => 'automotive-distance_measurement',
                'type' => 'string',
                'value' => 'mi',
                'description' => 'Format used to display and manage mileages for vehicles',
                'choices' => [
                    ['value' => 'mi', 'name' => 'Miles'],
                    ['value' => 'km', 'name' => 'Kilometres'],
                ],
                'order' => 10,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Vehicle URL structure',
                'config_key' => 'automotive-vehicles-url_building_format',
                'type' => 'string',
                'value' => 'vrm-make-model',
                'description' => 'Format used for vehicle stock links on website',
                'choices' => [
                    ['value' => 'vrm-make-model', 'name' => 'Generated as VRM-Make-Model'],
                    ['value' => 'title', 'name' => 'Title converted to URL'],

                ],
                'order' => 10,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Allow sales journey when Available Date in future',
                'config_key' => 'vehicle-available-date-sales-allowed',
                'type' => 'boolean',
                'value' => false,
                'description' => 'When enabled system will allow proceeding with sales journey (like SilverBullet) '
                    . 'when Available date is in future',
                'order' => 11,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Enable content versioning on offers',
                'config_key' => 'offers-versioning-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Stores previous versions of content for offers, '
                    . ' allows review/collaboration/approval of content',
                'order' => 11,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Content',
                'name' => 'Enable content versioning on content pages',
                'config_key' => 'pages-versioning-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Stores previous versions of content for content pages, '
                    . ' allows review/collaboration/approval of content',
                'order' => 11,
            ],
        ];
    }
}
