<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ChannelFeedExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        $description = '<a href="https://www.channable.com/" target="_blank">Channable</a> feed. '
            . 'When enabled, will grant access to URL for handling images:<br/>'
            . 'GET ' . route('tenant.feeds.channable', ['tenant' => tenant('id'), 'api_token' => config('auth.api_auth_token')]) . ' to list current vehicles on site<br/>';

        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Channable / FB Marketplace',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-channel-feed-enabled',
                'type' => 'boolean',
                'description' => $description,
                'value' => false,
            ],
        ];
    }
}
