<?php

namespace Tests\Feature;

use App\Http\Resources\MenuList;
use App\Http\Resources\MenuView;
use App\Http\Resources\SearchResponse;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Http\Resources\MediaEntryResource;
use Mtc\ContentManager\Http\Resources\MediaFileResource;
use Mtc\ContentManager\Http\Resources\MediaListResource;
use Mtc\ContentManager\Models\ContentElement;
use Mtc\ContentManager\Models\Media;
use Mtc\ContentManager\Models\Menu;
use Mtc\ContentManager\Models\MenuEntry;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\MercuryDataModels\Form;
use Mtc\MercuryDataModels\GlobalContent;
use Mtc\MercuryDataModels\Page;
use Tests\TenantTestCase;
use Tests\TestCase;
use Tests\UserForTenant;

class ViewEnquiryTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;


    public function testEnquiryView()
    {
        $enquiry = Enquiry::factory()->create();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('enquiries.show', $enquiry));
        $response->assertStatus(200);
        $this->assertArrayHasKey('id', $response->json('enquiry'));
        $this->assertArrayHasKey('title', $response->json('enquiry'));
        $this->assertArrayHasKey('message', $response->json('enquiry'));
        $this->assertArrayHasKey('enquiry', $response->json());
        $this->assertArrayHasKey('statuses', $response->json());
        $this->assertArrayHasKey('managers', $response->json());
    }

}
