<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AutoTraderEnrichedDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Enriched vehicle data',
                'name' => 'Fetch ad performance details',
                'config_key' => 'autotrader-advert-performance',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
                'description' => 'Pull vehicle performance details (price point, views and search results on AT)',
                'order' => 20,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Enriched vehicle data',
                'name' => 'Retrieve specs & features',
                'config_key' => 'vehicle-spec-providers-autotrader-enabled',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Not required when stock pull from AutoTrader is used',
                'order' => 30,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Enriched vehicle data',
                'name' => 'Display AutoTrader price indicator on front-end',
                'config_key' => 'autotrader-show-price-indicator',
                'type' => 'boolean',
                'value' => false,
                'min_tier' => 'pro',
                'description' => 'Add AutoTrader price indicator to catalog and full page ads pages',
                'order' => 21,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Enriched vehicle data',
                'name' => 'Display price indicator when value is equal or better than',
                'config_key' => 'autotrader-show-price-indicator-min-value',
                'type' => 'string',
                'value' => 'Good',
                'choices' => [
                    ['value' => 'HIGHER', 'name' => 'Higher price'],
                    ['value' => 'FAIR', 'name' => 'Fair price'],
                    ['value' => 'GOOD', 'name' => 'Good price'],
                    ['value' => 'GREAT', 'name' => 'Great price'],
                    ['value' => 'LOWER', 'name' => 'Lower price'],
                ],
                'min_tier' => 'pro',
                'order' => 22,
            ],

        ];
    }
}
