<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CapLookupOverrideAttributes extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'CAP',
                'name' => 'Vehicle lookup attributes to override',
                'config_key' => 'vehicle-spec-providers-cap-override-attributes',
                'min_tier' => 'standard',
                'type' => 'list',
                'choices' => [
                    ['value' => 'model_to_derivative', 'name' => 'Cap Model To Derivative'],
                    ['value' => 'registration_date_to_year', 'name' => 'Cap Registration Date To Year'],
                ],
                'value' => '',
                'description' => 'When looking up vehicle CAP the selected attribute will override vehicles fields if
                    the value is set'
            ],
        ];
    }
}
