<?php

namespace App\Checklist;

use App\Contracts\GoLiveChecklist;
use Mtc\MercuryDataModels\Tenant;

class ThemeDomainCheck extends GoLiveChecklist
{
    public function category(): string
    {
        return GoLiveChecklist::FRONTEND;
    }

    public function isApplicable(Tenant $site): bool
    {
        return !empty($site->theme_name);
    }

    public function key(): string
    {
        return 'theme_domain';
    }

    public function handle(): bool
    {
        return false;
    }
}
