<?php

namespace App\Modules\Leasing\Jobs;

use Mtc\MercuryDataModels\KeyloopLeaseVariantOptionMapping;

class VariantOptionMapImportJob extends BaseImportJob
{
    protected function importItem(array $item)
    {
        KeyloopLeaseVariantOptionMapping::query()->updateOrCreate(
            [
                'external_variant_id' => $item['external_variant_id'],
                'make_id' => $item['make_id'],
                'model_id' => $item['model_id'],
                'option_type' => $item['option_type'],
                'option_code' => $item['option_code'],
                'option_availability_code' => $item['option_availability_code'],
            ],
            [
                'was_recently_synced' => true,
            ]
        );
    }
}
