<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\MotorsCoUkExportJob;
use App\Traits\ChecksForExportMap;
use Illuminate\Foundation\Bus\DispatchesJobs;

class MotorsCoUk implements SalesChannel
{
    use DispatchesJobs;
    use ChecksForExportMap;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-motors-co-uk-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.motors_co_uk');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled() && !$this->hasActiveExportMap()) {
            $this->dispatch(new MotorsCoUkExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'motors-co-uk-dealer-id' => [
                'type' => 'text',
                'label' => 'Feed ID on Motors.co.uk'
            ],
        ];
    }
}
