<?php

namespace App\Modules\ServiceBooking\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Modules\ServiceBooking\Http\Requests\CreateBookingPackageRequest;
use App\Modules\ServiceBooking\Http\Requests\UpdateBookingPackageRequest;
use App\Modules\ServiceBooking\Http\Resources\ListServicePackages;
use App\Modules\ServiceBooking\Http\Resources\ViewServicePackage;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\ServicePackage;

class ServicePackageController extends Controller
{
    public function index(Request $request): ListServicePackages
    {
        $bookings = ServicePackage::query()
            ->latest()
            ->paginate();
        return new ListServicePackages($bookings);
    }

    public function store(CreateBookingPackageRequest $request): ViewServicePackage
    {
        $package = ServicePackage::query()->create($request->validated());
        return new ViewServicePackage($package);
    }

    public function show(ServicePackage $package): ViewServicePackage
    {
        return new ViewServicePackage($package);
    }

    public function update(UpdateBookingPackageRequest $request, ServicePackage $package): ViewServicePackage
    {
        $package->update($request->validated());
        return new ViewServicePackage($package);
    }

    public function destroy(ServicePackage $package): Response
    {
        $package->delete();
        return \response('ok');
    }
}
