<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CarWowExportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Car Wow',
                'name' => 'Enabled',
                'config_key' => 'sales-channels-car-wow-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Car Wow',
                'name' => 'FTP server Username',
                'config_key' => 'sales-channels-car-wow-ftp-username',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-car-wow-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Car Wow',
                'name' => 'FTP server Password',
                'config_key' => 'sales-channels-car-wow-ftp-password',
                'type' => 'secret',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-car-wow-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Sales Channels / Feeds',
                'group' => 'Car Wow',
                'name' => 'Export file name',
                'config_key' => 'sales-channels-car-wow-file-name',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.sales-channels-car-wow-enabled,true"
                ]
            ],
        ];
    }
}
