<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleTitleSlugDynamicRebuildSettings extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Automatically set vehicle title from make and model',
                'config_key' => 'auto-update-vehicle-title',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Automatically update slug if key details change',
                'config_key' => 'auto-update-vehicle-slug',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Only applicable if slug is based on VRM / Make / Model'
            ],
        ];
    }
}
