<?php

namespace App\Observers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Mtc\ContentManager\Contracts\GlobalContent;
use Mtc\ContentManager\Traits\EnsuresSlug;

class GlobalContentObserver extends \Mtc\ContentManager\Observers\GlobalContentObserver
{
    public function saved(GlobalContent $content)
    {
        Cache::forget(tenant('id') . "-global-content-" . $content->slug);
    }

    public function deleted(GlobalContent $content)
    {
        Cache::forget(tenant('id') . "-global-content-" . $content->slug);
    }
}
