<?php

namespace Tests\Tenant;

use Carbon\Carbon;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Models\Media;
use Tests\TenantTestCase;

class ClearOldMediaTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testRemoveOldMedia()
    {
        $media = Media::factory()->create(['created_at' => Carbon::now()->subYears(3), 'last_used' => Carbon::now()->subYears(3)]);
        $media2 = Media::factory()->create(['created_at' => Carbon::now()->subYears(3), 'last_used' => Carbon::now()->subYears(3)]);
        MediaUse::factory()->create(['media_id' => $media2]);
        $this->artisan('clear:unused-media')->assertExitCode(0);
        $this->assertFalse(Media::query()->where('id', $media->id)->exists());
        $this->assertTrue(Media::query()->where('id', $media2->id)->exists());
    }

    public function testRemoveOldMediaByTier()
    {
        Media::factory()->create(['created_at' => Carbon::now()->subYears(3), 'last_used' => Carbon::now()->subYears(3)]);
        Media::factory()->create(['created_at' => Carbon::now()->subYears(3),'last_used' => Carbon::now()->subMonths(16)]);
        Media::factory()->create(['created_at' => Carbon::now()->subYears(3),'last_used' => Carbon::now()->subMonths(10)]);
        Media::factory()->create(['created_at' => Carbon::now()->subYears(3),'last_used' => Carbon::now()->subMonths(5)]);
        Media::factory()->create(['created_at' => Carbon::now()->subYears(3),'last_used' => Carbon::now()->subMonth()]);
        $this->assertEquals(5, Media::query()->count());
        tenant()->tier = 'enterprise';
        $this->artisan('clear:unused-media')->assertExitCode(0);
        $this->assertEquals(4, Media::query()->count());

        tenant()->tier = 'pro';
        $this->artisan('clear:unused-media')->assertExitCode(0);
        $this->assertEquals(3, Media::query()->count());

        tenant()->tier = 'standard';
        $this->artisan('clear:unused-media')->assertExitCode(0);
        $this->assertEquals(2, Media::query()->count());

        tenant()->tier = 'lite';
        $this->artisan('clear:unused-media')->assertExitCode(0);
        $this->assertEquals(1, Media::query()->count());
    }
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testRemoveOldMediaChecksCreatedAt()
    {
        $media = Media::factory()->create(['created_at' => Carbon::now(), 'last_used' => Carbon::now()->subYears(3)]);
        $media2 = Media::factory()->create(['created_at' => Carbon::now(), 'last_used' => Carbon::now()->subYears(3)]);
        $media3 = Media::factory()->create(['created_at' => Carbon::now()->subYears(3), 'last_used' => Carbon::now()->subYears(3)]);
        $media4 = Media::factory()->create(['created_at' => Carbon::now()->subYears(3), 'last_used' => Carbon::now()->subYears(3)]);
        MediaUse::factory()->create(['media_id' => $media2]);
        MediaUse::factory()->create(['media_id' => $media4]);
        $this->artisan('clear:unused-media')->assertExitCode(0);
        $this->assertTrue(Media::query()->where('id', $media->id)->exists());
        $this->assertTrue(Media::query()->where('id', $media2->id)->exists());
        $this->assertFalse(Media::query()->where('id', $media3->id)->exists());
        $this->assertTrue(Media::query()->where('id', $media4->id)->exists());
    }
}
