<?php

namespace Tenant;

use App\OfferRepository;
use Mtc\MercuryDataModels\Media;
use Mtc\MercuryDataModels\VehicleFeature;
use Mtc\MercuryDataModels\VehicleOffer;
use Mtc\MercuryDataModels\VehicleStandardEquipment;
use Mtc\MercuryDataModels\VehicleTechnicalData;
use Tests\TenantTestCase;

class VehicleOfferRepositoryTest extends TenantTestCase
{
    public function testRestore()
    {
        $offer = VehicleOffer::factory()->create();
        $offer->delete();
        $repository = new OfferRepository();
        $this->assertTrue($repository->restore($offer->id));
    }

    public function testExportToRemote()
    {
        $repository = new OfferRepository();

        $offer = VehicleOffer::factory()->create();
        $media = Media::factory()->create();
        $offer->mediaUses()->create(['media_id' => $media->id]);
        VehicleFeature::factory(3)->create([
            'vehicle_type' => $offer->getMorphClass(),
            'vehicle_id' => $offer->id,
        ]);

        VehicleTechnicalData::factory(4)->create([
            'vehicle_type' => $offer->getMorphClass(),
            'vehicle_id' => $offer->id,
        ]);

        VehicleStandardEquipment::factory(5)->create([
            'vehicle_type' => $offer->getMorphClass(),
            'vehicle_id' => $offer->id,
        ]);


        $result = $repository->exportToRemote([$offer->id]);
        $this->assertEquals(1, count($result));
        $this->assertEquals(1, count($result[0]['media_uses']));
        $this->assertEquals(3, count($result[0]['features']));
        $this->assertEquals(4, count($result[0]['specs']));
        $this->assertEquals(5, count($result[0]['equipment']));

    }

    public function testCheckImportEntryValidity()
    {
        $repository = new OfferRepository();
        $result = $repository->checkImportEntryValidity([
            'slug' => 'foo',
        ], []);
        $this->assertEmpty($result['errors']);

        $result = $repository->checkImportEntryValidity([
            'slug' => null,
        ], []);
        $this->assertNotEmpty($result['errors']);

        VehicleOffer::factory()->create([
            'name' => 'foo',
            'slug' => 'foo',
        ]);

        $result = $repository->checkImportEntryValidity([
            'slug' => 'foo',
        ], []);
        $this->assertNotEmpty($result['errors']);

    }
}
