<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleFeature;
use Mtc\MercuryDataModels\VehicleStandardEquipment;
use Mtc\MercuryDataModels\VehicleTechnicalData;

class FixSpecDataMorphType extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fix:vehicle-spec-morph';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix morph type value after changing specs/feature/tech data to morphed from vehicle only';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $morphClass = (new Vehicle())->getMorphClass();
        VehicleFeature::query()
            ->whereNull('vehicle_type')
            ->update([
                'vehicle_type' => $morphClass
            ]);
        VehicleTechnicalData::query()
            ->whereNull('vehicle_type')
            ->update([
                'vehicle_type' => $morphClass
            ]);
        VehicleStandardEquipment::query()
            ->whereNull('vehicle_type')
            ->update([
                'vehicle_type' => $morphClass
            ]);
        return Command::SUCCESS;
    }
}
