<?php

namespace App\Http\Controllers;

use App\Http\Requests\AutosOnShowNotificationRequest;
use App\Jobs\ImportAutosOnShowFilesJob;
use App\Modules\ImageSync\AutosOnShow as AutosOnShowSync;
use App\Services\AutosOnShow;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\ApiNotification;

class AutosOnShowNotificationController extends Controller
{
    use DispatchesJobs;

    /**
     * Process Autos on Show notification about vehicle media
     *
     * @param AutosOnShowNotificationRequest $request
     * @return Response
     */
    public function store(AutosOnShowNotificationRequest $request)
    {
        $notification = ApiNotification::query()
            ->create([
                'provider' => AutosOnShowSync::PROVIDER_NAME,
                'data' => $request->input(),
                'headers' => $request->header(),
                'data_model' => 'vehicle',
                'reference' => $request->input('vehicleId'),
            ]);

        if ($request->vehicle()) {
            $this->dispatch(
                new ImportAutosOnShowFilesJob(
                    $request->vehicle(),
                    app(AutosOnShow::class),
                    $notification
                )
            );
            $notification->processed = true;
            $notification->save();
        }
        return response('ok');
    }
}
