<?php

namespace Database\Seeders\MercuryTheme;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\ContentElement;
use Mtc\MercuryDataModels\GlobalContent;

class GlobalContentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        GlobalContent::query()->truncate();
        collect($this->getList())
            ->each(fn ($entry) => GlobalContent::query()->create($entry));
    }

    private function getList()
    {
        $copyright = ContentElement::query()->where('slug', 'title')->first();
        $enquiryEmail = ContentElement::query()->where('slug', 'email-content')->first();
        $cookie = ContentElement::query()->where('slug', 'cookie-consent')->first();
        return [
            [
                'name' => 'Featured vehicles',
                'slug' => 'featured-vehicles',
                'ui_component' => 'UiResponsiveProductList',
                'element_id' => ContentElement::query()->where('slug', 'featured-vehicles')->first()?->id,
            ],
            [
                'name' => 'Copyright',
                'slug' => 'copyright',
                'element_id' => $copyright?->id,
                'content' => [
                    [
                        'id' => $copyright->fields()->where('slug', 'title')->first()?->id,
                        'slug' => 'title',
                        'content' => 'Website powered by <a href="//mtc.co.uk" target="_blank">mtc Autonomy</a>'
                    ]
                ],
            ],
            [
                'name' => 'Customer Enquiry Autoresponder',
                'slug' => 'enquiry-autoresponder-email-content',
                'element_id' => $enquiryEmail?->id,
                'content' => [
                    [
                        'id' => $enquiryEmail->fields()->where('slug', 'content')->first()?->id,
                        'slug' => 'content',
                        'content' => ''
                    ],
                    [
                        'id' => $enquiryEmail->fields()->where('slug', 'footer')->first()?->id,
                        'slug' => 'footer',
                        'content' => ''
                    ]
                ],
            ],
            [
                'name' => 'Cookie Consent',
                'slug' => 'cookie-consent',
                'element_id' => $cookie?->id,
                'content' => [
                    [
                        "id" => $cookie->fields()->where('slug', 'main-cookie-text')->first()?->id,
                        "slug" => "main-cookie-text",
                        "content" => "<p>We use cookies when you visit our site. These help us to give you the best experience on our website, analyse traffic and enable social media features. You can manage the cookies set on your device by clicking “Settings”. By clicking “Accept all”, you agree to the use of cookies unless you have disabled them. You can find out more information about cookies and about how we process personal data in our Cookies &amp; Privacy page.</p>"
                    ],
                    [
                        "id" => $cookie->fields()->where('slug', 'necessary-cookies')->first()?->id,
                        "slug" => "necessary-cookies",
                        "content" => "<p>We'd like to enable third party cookies to help us understand the effectiveness of our online marketing, so that we know if you have visited this website by clicking on an advert that we have placed.</p>"
                    ],
                    [
                        "id" => $cookie->fields()->where('slug', 'analytical-cookies')->first()?->id,
                        "slug" => "analytical-cookies",
                        "content" => "<p>We'd like to enable third party cookies to help us understand the effectiveness of our online marketing, so that we know if you have visited this website by clicking on an advert that we have placed</p>"
                    ],
                    [
                        "id" => $cookie->fields()->where('slug', 'marketing-cookies')->first()?->id,
                        "slug" => "marketing-cookies",
                        "content" => "<p>We'd like to enable third party cookies to help us understand the effectiveness of our online marketing, so that we know if you have visited this website by clicking on an advert that we have placed.</p>"
                    ]
                ]
            ],
        ];
    }
}
