<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use App\Jobs\FetchAutoTraderPerformanceData;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;

class AutoTraderDataFetch extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'auto-trader:fetch-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fetch AutoTrader data for stock';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (Settings::get('autotrader-advert-performance')) {
            $this->dispatch(new FetchAutoTraderPerformanceData());
        }
        return Command::SUCCESS;
    }
}
