<?php

namespace App\Console\Commands;

use App\VehicleStockSyncLogRepository;
use Illuminate\Console\Command;

class ClearVehicleStockSyncLog extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clear:vehicle-stock-sync-log';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean out old vehicle stock sync logs';

    /**
     * Execute the console command.
     */
    public function handle(VehicleStockSyncLogRepository $repository)
    {
        if (!$repository->enabled()) {
            return;
        }

        $repository->deleteOldLogs();
        $this->info("Old vehicle stock sync logs deleted");
    }
}
