<?php

namespace App\Console\Commands;

use App\TaxonomyMap;
use Illuminate\Console\Command;

class RemoveOrphanedTaxonomyMaps extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'taxonomy:cleanup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove all taxonomy maps that are missing a corresponding taxonomy';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $count = TaxonomyMap::whereDoesntHaveMorph('taxonomy', '*')->count();

        TaxonomyMap::whereDoesntHaveMorph('taxonomy', '*')->delete();

        $this->info("Successfully removed {$count} orphaned taxonomy maps.");

        return 0;
    }
}
