<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\MercuryDataModels\BodyStyleType;
use Mtc\MercuryDataModels\DrivetrainType;
use Mtc\MercuryDataModels\FuelType;
use Mtc\MercuryDataModels\Tenant;
use Mtc\MercuryDataModels\TransmissionType;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;

class SyncTaxonomyToTenants implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(private readonly string $type, private readonly Model $model)
    {
        $this->onQueue('sync');
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        tenancy()->runForMultiple(null, fn() => $this->sync());
    }

    private function sync()
    {
        match ($this->type) {
            'make' => VehicleMake::query()
                ->where('id', $this->model->id)
                ->update([
                    'name' => $this->model->name,
                    'autotrader_id' => $this->model->autotrader_id,
                    'logo' => $this->model->logo['path'] ?? null,
                    'monochrome_logo' => $this->model->monochrome_logo['path'] ?? null,
                    'primary_colour' => $this->model->primary_colour ?? null,
                    'secondary_colour' => $this->model->secondary_colour ?? null,
                ]),
            'model' => VehicleModel::query()
                ->where('id', $this->model->id)
                ->update([
                    'name' => $this->model->name,
                    'autotrader_id' => $this->model->autotrader_id,
                    'make_id' => $this->model->make_id
                ]),
            'fuel_type' => FuelType::query()
                ->where('name', $this->model->name)
                ->update([
                    'name' => $this->model->name,
                    'autotrader_id' => $this->model->autotrader_id,
                ]),
            'transmission' => TransmissionType::query()
                ->where('name', $this->model->name)
                ->update([
                    'name' => $this->model->name,
                    'autotrader_id' => $this->model->autotrader_id,
                ]),
            'body_style' => BodyStyleType::query()
                ->where('name', $this->model->name)
                ->update([
                    'name' => $this->model->name,
                    'autotrader_id' => $this->model->autotrader_id,
                ]),
            'drivetrain' => DrivetrainType::query()
                ->where('name', $this->model->name)
                ->update([
                    'name' => $this->model->name,
                    'autotrader_id' => $this->model->autotrader_id,
                ]),
        };
    }
}
