<?php

namespace Database\Seeders\Tenant;

use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\ContentElement;
use Mtc\MercuryDataModels\GlobalContent;
use PHPUnit\Util\Exception;

class EmailReservationConfirmationContentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (GlobalContent::query()->where('slug', 'customer-reservations-autoresponder')->exists()) {
            return;
        }

        $reservationElement = ContentElement::query()->where('slug', 'email-content')->first();

        $data = [
                'name' => 'Customer Reservations Autoresponder',
                'slug' => 'customer-reservations-autoresponder',
                'element_id' => $reservationElement?->id,
                'content' => [
                    [
                        'id' => $reservationElement->fields()->where('slug', 'content')->first()?->id,
                        'slug' => 'content',
                        'content' => ''
                    ],
                    [
                        'id' => $reservationElement->fields()->where('slug', 'footer')->first()?->id,
                        'slug' => 'footer',
                        'content' => ''
                    ]
                ],
            ];
            GlobalContent::query()->create($data);
    }
}
