<?php

namespace App\Console;

use App\Console\Commands\CleanApiUsage;
use App\Console\Commands\ClearOldFailedJobs;
use App\Console\Commands\DeployCommand;
use App\Console\Commands\GenerateInvoices;
use App\Console\Commands\IngestEnquiries;
use App\Console\Commands\MtcOldStaffCheck;
use App\Console\Commands\NotifyOverdueInvoices;
use App\Console\Commands\RemoveOrphanedTaxonomyMaps;
use App\Console\Commands\RunKeyloopLeasingPostImportTasks;
use App\Console\Commands\SalesChannelExportCommand;
use App\Console\Commands\SyncAutoTraderTaxonomies;
use App\Console\Commands\SyncCAPTaxonomies;
use App\Console\Commands\SyncLeaseData;
use App\Console\Commands\TenantsSyncTaxonomies;
use App\Console\Commands\UpdateCurrencies;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Config;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [];

    /**
     * Define the application's command schedule.
     *
     * @param Schedule $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        if (Config::get('app.run_deploy_as_cron')) {
            $schedule->command(DeployCommand::class)->everyMinute();
        }
        $schedule->command('tenants:run', [IngestEnquiries::class])->everyMinute();
        $schedule->command('tenants:run', ['reservations:ingest'])->everyMinute();
        $schedule->command('tenants:run', ['bookings:discard-draft'])->everyMinute();
        $schedule->command('tenants:run', ['bookings:ingest'])->everyMinute();
        $schedule->command('tenants:run', ['reports:run'])->everyMinute();
        $schedule->command('tenants:run', ['export-maps:run'])->everyMinute();
        $schedule->command('tenants:run', ['sync:vehicles'])->hourly();
        $schedule->command('tenants:run', ['sync:vehicle-images'])->hourly();
        $schedule->command('tenants:run', [RunKeyloopLeasingPostImportTasks::class])->hourly();
        $schedule->command('tenants:run', ['export:silver-bullet'])->everyFourHours();
        $schedule->command(ClearOldFailedJobs::class)->dailyAt('03:03');
        $schedule->command(CleanApiUsage::class)->dailyAt('03:08');
        $schedule->command(MtcOldStaffCheck::class)->everySixHours();
        $schedule->command('tenants:run', ['clear:api-notifications'])->everySixHours();
        $schedule->command('tenants:run', ['vehicles:cap-id-lookup'])->everySixHours();
        $schedule->command('tenants:run', [SyncLeaseData::class])->weeklyOn(2, '09:00');
        $schedule->command('tenants:run', ['vehicles:purge-orphaned-data'])
            ->everyThirtyMinutes()
            ->unlessBetween('08:00', '22:00');
        $schedule->command('tenants:run', ['sales-channels:export'])->twiceDaily(8, 18);
        $schedule->command(SalesChannelExportCommand::class)->everyTwoHours();

        $schedule->command('tenants:run', ['stats:generate'])->dailyAt('00:04');
        $schedule->command('tenants:run', ['clear:audit'])->dailyAt('00:20');
        $schedule->command('tenants:run', ['clear:api-notifications'])->dailyAt('00:25');
        $schedule->command('tenants:run', ['pages:clean-trashed-pages'])->dailyAt('00:30');
        $schedule->command('tenants:run', ['clear:unused-media'])->dailyAt('00:35');
        $schedule->command('tenants:run', ['pages:delete-old-versions'])->dailyAt('00:40');
        $schedule->command('tenants:run', ['clear:sales-channel-history'])->dailyAt('00:50');
        $schedule->command('tenants:run', ['filter:refresh-index'])->dailyAt('01:00');
        $schedule->command('tenants:run', ['vehicles:purge-soft-deletes'])->dailyAt('01:10')->withoutOverlapping();
        $schedule->command('tenants:run', ['clear:vehicle-stock-sync-log'])->dailyAt('01:30');
        $schedule->command('tenants:run', ['clear:stats'])->dailyAt('03:00');
        $schedule->command('tenants:run', ['auto-trader:fetch-data'])->dailyAt('03:11');
        $schedule->command('tenants:run', ['vehicles:find-coordinates'])->everySixHours();
        $schedule->command('tenants:run', ['filter:update-search-index'])->everyTwoHours();
        $schedule->command(SyncAutoTraderTaxonomies::class)->dailyAt('05:00');
        $schedule->command('tenants:run', ['vehicles:update-search-content'])->dailyAt('05:11');
        $schedule->command(SyncCAPTaxonomies::class)->dailyAt('05:15');
        $schedule->command(TenantsSyncTaxonomies::class)->dailyAt('05:30');
        $schedule->command('tenants:run', ['occupop:sync-jobs'])->dailyAt('06:00');
        $schedule->command(RemoveOrphanedTaxonomyMaps::class)->dailyAt('06:30');
        $schedule->command(GenerateInvoices::class)->dailyAt('08:00');
        $schedule->command(NotifyOverdueInvoices::class)->dailyAt('08:30');
        $schedule->command('tenants:run', ['vehicles:update-search-content'])->dailyAt('15:11');
        $schedule->command(UpdateCurrencies::class)->dailyAt('23:11');
        $schedule->command('tenants:run', ['notifications:prune'])->dailyAt('03:00');
        $schedule->command('check:failed-enquiry-actions')->hourly();
        $schedule->command('tenants:run', ['pages:clear-orphan-content'])->dailyAt('01:20');

        $schedule->command('tenants:run', ['finance:export-vehicles'])->twiceDaily();
        $schedule->command('tenants:run', ['finance:request-quotes'])->everyFourHours();

        if (config('app.purge_media')) {
            $schedule->command('tenants:run', ['media:purge-stray-files'])->monthlyOn(1, '03:31');
            $schedule->command('tenants:run', ['media:purge-orphaned-provider-images'])
                ->weeklyOn(7, '22:11')
                ->withoutOverlapping();
        }
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
