<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\MercuryDataModels\VehiclePackage;

class VehiclePackageController extends Controller
{
    public function index()
    {
        return VehiclePackage::query()->paginate();
    }

    public function store(Request $request)
    {
        $vehicle_package = VehiclePackage::query()->create($request->input());
        return $this->show($vehicle_package);
    }

    public function show(VehiclePackage $vehicle_package)
    {
        return [
            'data' => $vehicle_package,
            'available_fields' => $this->getFields(),
            'conditions' => $this->getConditionsForDisplay($vehicle_package),
            'vehicle_types' => $this->getVehicleTypes(),
        ];
    }

    public function update(Request $request, VehiclePackage $vehicle_package)
    {
        $input = $request->input();
        $input['conditions'] = $this->getStorableConditions($input['conditions']);
        $vehicle_package->update($input);
        return $this->show($vehicle_package);
    }

    public function destroy(VehiclePackage $vehicle_package)
    {
        $vehicle_package->delete();
        return $this->index();
    }

    private function getFields()
    {
        return [
            'type' => 'Type',
            'make.name' => 'Vehicle make',
            'model.name' => 'Vehicle model',
            'fuelType.name' => 'Fuel Type',
            'transmission.name' => 'Transmission',
            'bodyStyle.name' => 'Body Style',
            'price' => 'Price (excluding VAT and VRT)',
            'engine_size_cc' => 'Engine size (cc)',
        ];
    }

    private function getConditionsForDisplay(VehiclePackage $vehicle_package): array
    {
        return collect($vehicle_package->conditions)->map(function ($condition) {
            if ($condition['value']['operator'] == 'in' && is_array($condition['value']['value'])) {
                $condition['value']['value'] = implode(',', $condition['value']['value']);
            }
            return $condition;
        })->toArray();
    }

    private function getStorableConditions(array $conditions): array
    {
        return collect($conditions)->map(function ($condition) {
            $condition['value'] = $condition['value']['operator'] == 'in'
                ? $this->convertConditionValueToArray($condition['value'])
                : $condition['value'];

            return $condition;
        })->toArray();
    }

    private function convertConditionValueToArray(array $value): array
    {
        $values = explode(',', $value['value']);
        $values = collect($values)->map(fn($value) => trim($value))->toArray();
        $value['value'] = $values;
        return $value;
    }

    private function getVehicleTypes(): array
    {
        return [
            'vehicle' => 'Stock Vehicle',
            'lease_vehicle' => 'Leasing Vehicle',
        ];
    }
}
