<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PasswordResetNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(private $password = null)
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return MailMessage
     */
    public function toMail($notifiable)
    {
        $url = app()->environment('local')
            ? '//localhost:8000/login?email=' . $notifiable->email
            : url('login?email=' . $notifiable->email);
        return (new MailMessage())
            ->subject('Password reset for you on ' . config('app.name'))
            ->line('Password has been reset for your access to ' . config('app.name'))
            ->when($this->password, function (MailMessage $message) use ($notifiable) {
                $message
                    ->line('Your login email: ' . $notifiable->email)
                    ->line('Your temporary password: ' . $this->password);
            })
            ->action('Log In', $url);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
