<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SkodaStockSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Offer sync',
                'group' => 'Skoda',
                'name' => 'Enabled',
                'config_key' => 'stock-skoda-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'order' => 1,
                'description' => 'Automatically pull vehicle data from <a href="https://stock-cars.skoda-auto.com/941/en-IE/" target="_blank">Skoda stock cars</a> IE region.',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Offer sync',
                'group' => 'Skoda',
                'name' => 'Synchronize images',
                'config_key' => 'stock-skoda-sync-images',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'order' => 2,
                'description' => 'Retrieve images from DMS and add them to vehicles when importing'
            ],
        ];
    }
}
