<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SkupenetStockSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Skupenet',
                'name' => 'Enabled',
                'config_key' => 'stock-skupenet-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'order' => 1,
                'description' => '<a href="http://skupenet.com/" target="_blank">Skupenet</a> sync integration.',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Skupenet',
                'name' => 'Synchronize images',
                'config_key' => 'stock-skupenet-sync-images',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'order' => 2,
                'description' => 'Retrieve images from DMS and add them to vehicles when importing'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Skupenet',
                'name' => 'Partner Id',
                'config_key' => 'stock-skupenet-partner-id',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'order' => 3,
                'validation_rules' => [
                    "required_if:values.stock-skupenet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Skupenet',
                'name' => 'Password',
                'config_key' => 'stock-skupenet-password',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'order' => 4,
                'validation_rules' => [
                    "required_if:values.stock-skupenet-enabled,true"
                ]
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Skupenet',
                'name' => 'Only import vehicles with price set',
                'config_key' => 'stock-skupenet-sync-with-price',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'order' => 5,
            ],
        ];
    }
}
