<?php

namespace App\Crm\Config;

use App\Facades\Settings;

class DealerWebConfig
{
    protected function getSetting(string $key): mixed
    {
        $prefix = app()->isProduction() ? '' : 'test_';
        return Settings::get($prefix . $key);
    }

    public function enabled(): bool
    {
        return (bool) Settings::get('dealerweblms-crm-enabled');
    }

    public function username(): ?string
    {
        return $this->getSetting('dealerweblms-lms-username');
    }

    public function dealerNo(): ?string
    {
        return $this->getSetting('dealerweblms-dealer-no');
    }

    public function password(): ?string
    {
        return $this->getSetting('dealerweblms-password');
    }

    public function fallbackDealership(): ?string
    {
        return Settings::get('dealerweblms-fallback-dealerweb-dealer');
    }
}
