<?php

namespace App\Modules\ServiceBooking\Http\Resources;

use App\Facades\Settings;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Str;

class ViewServiceBooking extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->load([
            'location',
            'packages',
            'deliveryOption',
        ]);
        $this->resource->data = collect($this->resource->data ?? [])
            ->keyBy(fn($value, $name) => Str::title(str_replace('_', ' ', $name)));
        $this->resource->preview_image = $this->previewImage();
        return parent::toArray($request);
    }

    public function previewImage(): string
    {
        return 'https://cdn.imagin.studio/getImage?' . http_build_query([
                'customer' => Settings::get('imagin-placeholders-client-key') ?: config('services.imagin-studio.key'),
                'make' => $this->resource->vehicle_data['make'] ?? null,
                'modelFamily' => $this->resource->vehicle_data['model'] ?? null,
                'paintdescription' => $this->resource->vehicle_data['colour'] ?? null,
                'modelYear' => $this->resource->vehicle_data['model_year'] ?? null,
                'aspectRatio' => '16:9',
                'zoomLevel' => 50,
            ]);
    }
}
