<?php

namespace Tenant;

use App\Facades\Settings;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;
use Tests\TenantTestCase;

class VehicleObserverTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testUpdatesTitle()
    {
        Settings::update('auto-update-vehicle-title', true);
        $make = VehicleMake::factory()->create(['name' => 'Audi']);
        $model = VehicleModel::factory()->create(['name' => 'A6']);

        $vehicle = Vehicle::factory()->create([
            'title' => null,
            'make_id' => null,
            'model_id' => null,
        ]);
        $vehicle2 = Vehicle::factory()->create([
            'title' => 'Audi',
            'make_id' => $make->id,
            'model_id' => null,
        ]);
        $vehicle3 = Vehicle::factory()->create([
            'title' => 'Audi',
            'make_id' => null,
            'model_id' => $model->id,
        ]);
        $vehicle4 = Vehicle::factory()->create([
            'title' => null,
            'make_id' => $make->id,
            'model_id' => $model->id,
        ]);

        $vehicle->update([
            'make_id' => $make->id,
            'model_id' => $model->id,
        ]);

        $vehicle2->update([
            'make_id' => $make->id,
            'model_id' => $model->id,
        ]);

        $vehicle3->update([
            'make_id' => $make->id,
            'model_id' => $model->id,
        ]);

        $vehicle4->update([
            'make_id' => $make->id,
            'model_id' => $model->id,
        ]);

        $this->assertEquals('Audi A6', $vehicle->title);
        $this->assertEquals('Audi A6', $vehicle2->title);
        $this->assertEquals('Audi A6', $vehicle3->title);
        $this->assertEquals('Audi A6', $vehicle4->title);
    }
}
