<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\MercuryDataModels\Tenant;
use Mtc\MercuryDataModels\Vehicle;

class PhyronNotificationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return $this->validToken()
            && Tenant::query()->where('id', $this->input('site'))->exists();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'api_token' => 'required',
            'site' => 'required',
            'video' => 'sometimes',
            'images' => 'array',
            'vehicle_id' => 'required',
        ];
    }

    public function tenant(): string
    {
        return $this->input('site');
    }


    public function vehicle(): Vehicle
    {
        return Vehicle::query()
            ->where('uuid', $this->input('vehicle_id'))
            ->firstOrFail();
    }

    private function validToken(): bool
    {
        return config('auth.api_auth_token') === $this->input('api_token');
    }
}
