<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class DealerWebLmsTestEndpointSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect([
            'test_dealerweblms-dealerid',
        ])->each(fn($key) => Settings::delete($key));

        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Test LMS Endpoint',
                'config_key' => 'test_dealerweblms-endpoint',
                'type' => 'string',
                'value' => '',
                'description' => 'The test endpoint for Dealer Web LMS integration. Used in non-production environments.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Dealer Web LMS',
                'name' => 'Test Dealer No',
                'config_key' => 'test_dealerweblms-dealer-no',
                'type' => 'string',
                'value' => '',
                'description' => 'The test Dealer Number used for integration. Used in non-production environments.'
            ],
        ];
    }
}
