<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class PinewoodCRMSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Pinewood',
                'name' => 'Enabled',
                'config_key' => 'pinewood-crm-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => '<a href="https://www.pinewood.ai/" target="_blank">Pinewood CRM</a> integration.'
                    . ' Allows exporting leads to Pinewood system',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Pinewood',
                'name' => 'API Username',
                'config_key' => 'pinewood-crm-username',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.stock-pinewood-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Pinewood',
                'name' => 'API Password',
                'config_key' => 'pinewood-crm-password',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.stock-pinewood-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Pinewood',
                'name' => 'Fallback location ID',
                'config_key' => 'pinewood-fallback-location-id',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'description' => 'If location cannot be determined for a lead this fallback will be used.'
                    . ' Value should be the uuid hash',
            ],
        ];
    }
}
