<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Mtc\MercuryDataModels\Booking;
use Mtc\MercuryDataModels\BookingStatus;
use Mtc\MercuryDataModels\ReportingStat;

class DiscardDraftBookings extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'bookings:discard-draft';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Discard draft booking after 15 minutes of inactivity';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        Booking::query()
            ->where('status', BookingStatus::DRAFT)
            ->where('updated_at', '<=', Carbon::now()->subMinutes(15))
            ->update([
                'status' => BookingStatus::CANCELLED
            ]);
    }
}
