<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\HeyCarExportJob;
use App\Traits\ChecksForExportMap;
use Illuminate\Foundation\Bus\DispatchesJobs;

class HeyCar implements SalesChannel
{
    use DispatchesJobs;
    use ChecksForExportMap;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-hey-car-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.hey_car');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled() && !$this->hasActiveExportMap()) {
            $this->dispatch(new HeyCarExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'hey-car-dealer-id' => [
                'type' => 'text',
                'validation' => [
                    'required',
                ],
                'label' => 'Dealership name on Hey car'
            ],
        ];
    }
}
