<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FilterPerPageSetting extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Per page limit',
                'config_key' => 'filter-results-per-page',
                'type' => 'int',
                'value' => 15,
                'order' => 11,
                'description' => 'How many results to show per page'
            ],
        ];
    }
}
