<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class BeepBeepValuationSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'BeepBeep',
                'name' => 'Enabled',
                'config_key' => 'valuation-beepbeep-enabled',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'BeepBeep',
                'name' => 'Api Key',
                'config_key' => 'valuation-beepbeep-api_key',
                'type' => 'string',
                'min_tier' => 'pro',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.valuation-beepbeep-enabled,true"
                ]
            ],
        ];
    }
}
